function writeHOB(basename,hob)
% writeHOB(basename,hob)  --- writing heads observation file
% Tijs Dekker 160707

fid=fopen([basename,'.hob'],'wt');

%0.
fprintf(fid,'# MATLAB writeHOB %s\r\n',datestr(now));
fprintf(    '# MATLAB writeHOB %s\n'  ,datestr(now));

%1.
fprintf(fid,'%10i%10i%10i\r\n',hob.NH, hob.MOBS, hob.MAXM);

%2.
fprintf(fid,'%10g%10g\r\n',hob.TOMULTH,hob.EVH);

%3.
for i=1:hob.NH
    fprintf(fid,'%11s% 11g% 11g% 11g% 11g% 11g% 11g% 11g% 20g% 11g% 11g% 11g\r\n',...
    char(hob.OBSNAM{i}),hob.LAYER(i),hob.ROW(i),hob.COLUMN(i),hob.IREFSP(i),hob.TOFFSET(i),hob.ROFF(i),...
    hob.COFF(i),hob.HOBS(i),hob.STATISTIC(i),hob.STATFLAG(i),hob.PLOTSYMBOL(i));

    %4
    %used when there are observations for more than one layer

    if hob.IREFSP(i)<0
        %5
        fprintf(fid,'%10g\r\n',hob.ITT(i));
        
        for iI=1:abs(hob.IREFSP(i))
        %6
        fprint('not yet implemented')
        end
    end
end
fclose(fid);
